from OpenGL.GL import *
from OpenGL.GLU import *
from pygame.locals import *
from math import *
import array
import pygame
import time
import sys
from random import random
import shader
from glew import *


X = 800
Y = 600

def init():    
    global texID1, texID2

    pygame.init()    
    pygame.display.set_mode((X, Y), DOUBLEBUF | OPENGL)

    glewInit()
    glewGetExtension("GL_ARB_multitexture")

    shader.create(X, Y)

    # make a texture for the framebuffer
    glEnable(GL_TEXTURE_2D)

    texID1 = glGenTextures(1)
    texID2 = glGenTextures(1)

    data = '\0' * X * Y * 4

    glBindTexture(GL_TEXTURE_2D, texID1)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)

    glBindTexture(GL_TEXTURE_2D, texID2)
    glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, X, Y, 0, GL_RGBA, GL_UNSIGNED_BYTE, data)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
    #glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_R, GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
                    

iteration = 0

def draw():
    global iteration

    iteration += 1

    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA, GL_ONE)

    if iteration % 2 == 0:
        glActiveTextureARB(GL_TEXTURE0_ARB)
        glEnable(GL_TEXTURE_2D)
        glBindTexture(GL_TEXTURE_2D, texID1)
        glActiveTextureARB(GL_TEXTURE1_ARB)
        glEnable(GL_TEXTURE_2D)
        glBindTexture(GL_TEXTURE_2D, texID2)
    else:
        glActiveTextureARB(GL_TEXTURE0_ARB)
        glEnable(GL_TEXTURE_2D)
        glBindTexture(GL_TEXTURE_2D, texID2)
        glActiveTextureARB(GL_TEXTURE1_ARB)
        glEnable(GL_TEXTURE_2D)
        glBindTexture(GL_TEXTURE_2D, texID1)

    glFlush();

    glActiveTextureARB(GL_TEXTURE0_ARB)
    glDisable(GL_TEXTURE_2D)
    glActiveTextureARB(GL_TEXTURE1_ARB)
    glDisable(GL_TEXTURE_2D)
    
    glPointSize(2)
    glBegin(GL_POINTS)
    for i in xrange(3000):
        glColor4f(random(), random(), random(), 1)
        glVertex3f(random() * 0.1 + 0.9, random() * 2 - 1, 1)
    glEnd()
    glEnable(GL_TEXTURE_2D)

    # draw the texture
    shader.enable()
    glBegin(GL_QUADS)
    glColor4f(1, 1, 1, 1)
    glVertex3f(-1, -1, 1); glTexCoord2f(1, 0)
    glVertex3f(1, -1, 1);  glTexCoord2f(1, 1)
    glVertex3f(1, 1, 1);   glTexCoord2f(0, 1)
    glVertex3f(-1, 1, 1);  glTexCoord2f(0, 0)
    glEnd()
    shader.disable()

    if iteration % 2 == 0:
        # copy it into a texture
        glActiveTextureARB(GL_TEXTURE0_ARB)
        glBindTexture(GL_TEXTURE_2D, texID2)
        glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)
    else:
        # copy it into a texture
        glActiveTextureARB(GL_TEXTURE0_ARB)
        glBindTexture(GL_TEXTURE_2D, texID1)
        glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, X, Y, 0)        

    

def mainloop():
    glClearColor(0, 0, 0, 0)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)

    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    
    draw()
    
    for ev in pygame.event.get():
        if ev.type == QUIT: sys.exit()
        elif ev.type == KEYDOWN and ev.key == K_SPACE:
            toggle = not toggle
    pygame.display.flip()


if __name__ == '__main__':
    init()
    while 1:
        mainloop()
        time.sleep(0.001)
